/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

class SingleColumnLegendDrawable
implements Drawable,
Serializable {
    String[] legendItems_;
    Color[] colors_;
    RelativePosition position_;
    Font legendFont_;
    int boxSize_;
    Color textColor_;
    Color backgroundColor_;

    public SingleColumnLegendDrawable(String[] stringArray, Color[] colorArray, RelativePosition relativePosition, Font font, int n, Color color, Color color2) {
        this.legendItems_ = stringArray;
        this.colors_ = colorArray;
        this.position_ = relativePosition;
        this.legendFont_ = font;
        this.boxSize_ = n;
        this.textColor_ = color;
        this.backgroundColor_ = color2;
    }

    public void drawOn(Canvas3D canvas3D, Graphics graphics) {
        int n;
        Dimension dimension = canvas3D.getSize();
        graphics.setFont(this.legendFont_);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.legendItems_.length) {
            if (n2 < fontMetrics.stringWidth(this.legendItems_[n3])) {
                n2 = fontMetrics.stringWidth(this.legendItems_[n3]);
            }
            ++n3;
        }
        int n4 = fontMetrics.getHeight();
        int n5 = 3;
        int n6 = fontMetrics.getMaxDescent();
        if (n5 * 2 < n6) {
            n5 = (int)((double)n6 / 2.0 + 0.5);
        }
        if (n4 > (n = this.boxSize_ + 2 * n5)) {
            n = n4 - n6 + n5;
        }
        int n7 = n2 + (this.boxSize_ + 2 * n5) + n5 + 4;
        int n8 = n * this.legendItems_.length + 4;
        int n9 = this.position_.left(dimension.width, n7);
        int n10 = this.position_.top(dimension.height, n8);
        graphics.setColor(this.backgroundColor_);
        graphics.fillRect(n9, n10, n7, n8);
        int n11 = (int)((double)(n10 + 2) + (double)(n + fontMetrics.getHeight()) / 2.0 + 0.5) - fontMetrics.getMaxDescent();
        int n12 = n9 + 2 + n5;
        int n13 = n10 + 2 + (int)(((double)(n - this.boxSize_) + 0.5) / 2.0);
        int n14 = 0;
        while (n14 < this.legendItems_.length) {
            graphics.setColor(this.backgroundColor_);
            graphics.draw3DRect(n12, n13, this.boxSize_, this.boxSize_, true);
            graphics.draw3DRect(n12 + 1, n13 + 1, this.boxSize_ - 2, this.boxSize_ - 2, true);
            graphics.setColor(this.colors_[n14]);
            graphics.drawRect(n12 + 2, n13 + 2, this.boxSize_ - 4, this.boxSize_ - 4);
            graphics.fillRect(n12 + 2, n13 + 2, this.boxSize_ - 4, this.boxSize_ - 4);
            graphics.setColor(this.textColor_);
            graphics.drawString(this.legendItems_[n14], n12 + this.boxSize_ + n5, n11);
            n13 += n;
            n11 += n;
            ++n14;
        }
        graphics.setColor(this.backgroundColor_);
        graphics.draw3DRect(n9, n10, n7, n8, false);
        graphics.draw3DRect(n9 + 1, n10 + 1, n7 - 2, n8 - 2, false);
    }
}

